<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Logpost extends Minion_Task {

    protected $_options = array(
        'name'  => NULL
    );

    protected function _execute(array $params){
        $params = Helper::getConfigByName($params['name']);

        /* Check connection before continuing, if local searchd is down no need to bother storage */
        Database::instance('logpost_'.$params['database'])->connect();

        $logpost = null;
        $fields = [];
        $net = DB::expr("l.group AS net");
        $datetime = DB::expr('extract(epoch FROM l.datetime) AS datetime');
        if(Helper::isCuttedStorage()) {
            $fields = ['id', 'net', 'client_id', 'datetime', 'link', 'os_ver', 'referer' ];
            $logpost = DB::select("l.id", $net, "l.client_id", $datetime, "l.link", 'l.os_ver', 'l.data');
        }else{
            $fields = ['id', 'net', 'client_id', 'version', 'location', 'datetime', 'link', 'os_ver', 'referer', 'fake'];
            $logpost = DB::select("l.id", $net, "l.client_id", "c.version", 'c.location', $datetime, "l.link", 'l.os_ver', 'l.data');
        }


        $logpost = $logpost->from(['logpost', 'l'])
            ->join(['clients', 'c'])
            ->on('l.client_id', '=', 'c.id')
            ->where('l.id', '>', Helper::getCounter($params['name']))
            ->and_where('l.id', '<=', $params['limit'])
            ->order_by('l.id')
            ->limit(5000)
            ->execute('storage')
            ->as_array();

        /* Try multiple insert */
        if(!empty($logpost)) {
            $insert = DB::insert($params['name'], $fields);
            foreach ($logpost as $value) {
                $value['fake'] = 'all';
                $value['link'] = strtok($value['link'], '?');
                if(!Helper::isCuttedStorage()) {
                    $value['location'] = Helper::locationToInt($value['location']);
                }
                if(Helper::isJson($value['data']) && isset(json_decode($value['data'], true)['Referer'])){
                    $value['referer'] = json_decode($value['data'], true)['Referer'];
                }else{
                    $value['referer'] = '';
                }
                unset($value['data']);

                $insert->values($value);
            }

            try{
                $insert->execute('logpost_'.$params['database']);
            }catch (Exception $e){
                Minion_CLI::write(substr($e, 0, 500));
                $update = DB::select(DB::expr('max(id) AS max'))
                    ->from($params['name'])
                    ->where('id', '<', $params['limit'])
                    ->execute('logpost_'.$params['database'])
                    ->as_array();
                Helper::updCounter($update[0]['max'], $params['name']);
                exit;
            }

            /* Update counter */
            $value = end($logpost);
            Helper::updCounter($value['id'], $params['name']);
        }else{
            sleep(30);
        }
    }
}